/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.launching;

import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ResourceUtil;
import com.aptana.ruby.debug.core.RubyDebugCorePlugin;
import com.aptana.ruby.internal.debug.core.RubyDebuggerProxy;
import com.aptana.ruby.internal.debug.core.launching.Messages;
import com.aptana.ruby.internal.debug.core.model.RubyDebugTarget;
import com.aptana.ruby.internal.debug.core.model.RubyProcessingException;
import com.aptana.ruby.launching.RubyLaunchingPlugin;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.osgi.framework.Bundle;

public class RubyDebuggerLaunchDelegate
extends LaunchConfigurationDelegate {
    private static final String RDEBUG_IDE = "rdebug-ide";
    private static final String DEBUGGER_PORT_SWITCH = "--port";
    private static final String END_OF_ARGUMENTS_DELIMETER = "--";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ArrayList<? extends String> commandList = new ArrayList<String>();
        IPath rubyExecutablePath = this.rubyExecutable(configuration);
        commandList.add(rubyExecutablePath.toOSString());
        commandList.addAll(this.interpreterArguments(rubyExecutablePath, configuration));
        String host = configuration.getAttribute("com.aptana.ruby.debug.ATTR_REMOTE_HOST", "localhost");
        int port = -1;
        if (mode.equals("debug")) {
            port = RubyDebuggerLaunchDelegate.findFreePort();
            if (port == -1) {
                this.abort(Messages.RubyDebuggerLaunchDelegate_0, null);
            }
            commandList.addAll(this.debugArguments(rubyExecutablePath, host, port, configuration));
        }
        IPath workingDir = this.getWorkingDirectory(configuration);
        String fileToLaunch = this.fileToLaunch(configuration);
        if (fileToLaunch.equals("Rakefile") || fileToLaunch.endsWith(String.valueOf(File.separator) + "Rakefile")) {
            IPath rakeFilePath = Path.fromOSString((String)fileToLaunch);
            IPath parent = rakeFilePath.removeLastSegments(1);
            IPath rakePath = RubyLaunchingPlugin.getRakePath((IPath)parent);
            String rakePathString = rakePath == null ? "rake" : rakePath.toOSString();
            commandList.add(rakePathString);
            workingDir = parent;
        } else {
            commandList.add(fileToLaunch);
        }
        commandList.addAll(this.programArguments(configuration));
        Process process = DebugPlugin.exec((String[])commandList.toArray(new String[commandList.size()]), (File)(workingDir == null ? null : workingDir.toFile()), (String[])this.getEnvironment(configuration));
        String label = (String)commandList.get(0);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(IProcess.ATTR_PROCESS_TYPE, "ruby");
        IProcess p = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)label, map);
        if (mode.equals("debug")) {
            RubyDebugTarget target = new RubyDebugTarget(launch, host, port);
            target.setProcess(p);
            RubyDebuggerProxy proxy = new RubyDebuggerProxy(target, true);
            try {
                proxy.start();
                launch.addDebugTarget((IDebugTarget)target);
            }
            catch (RubyProcessingException e) {
                RubyDebugCorePlugin.log(e);
                target.terminate();
            }
            catch (IOException e) {
                RubyDebugCorePlugin.log(e);
                target.terminate();
            }
        }
    }

    private Collection<? extends String> programArguments(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> commandList = new ArrayList<String>();
        String programArgs = configuration.getAttribute("com.aptana.ruby.debug.ATTR_PROGRAM_ARGUMENTS", null);
        if (programArgs != null) {
            String[] stringArray = DebugPlugin.parseArguments((String)programArgs);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                commandList.add(arg);
                ++n2;
            }
        }
        return commandList;
    }

    private String fileToLaunch(ILaunchConfiguration configuration) throws CoreException {
        File file;
        String program = configuration.getAttribute("com.aptana.ruby.debug.ATTR_FILE_NAME", null);
        if (program == null) {
            this.abort(Messages.RubyDebuggerLaunchDelegate_1, null);
        }
        if ((file = new File(program)).exists()) {
            return program;
        }
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(program));
        if (iFile == null || !iFile.exists()) {
            this.abort(MessageFormat.format(Messages.RubyDebuggerLaunchDelegate_2, program), null);
        }
        return iFile.getLocation().toOSString();
    }

    private Collection<? extends String> debugArguments(IPath rubyExecutablePath, String host, int port, ILaunchConfiguration configuration) throws CoreException {
        IPath workingDir = this.getWorkingDirectory(configuration);
        ArrayList<String> commandList = new ArrayList<String>();
        IPath rdebug = RubyLaunchingPlugin.getBinaryScriptPath((String)RDEBUG_IDE, this.getRDebugIDELocations(rubyExecutablePath), (IPath)workingDir);
        if (rdebug == null) {
            this.abort(Messages.RubyDebuggerLaunchDelegate_3, null);
        }
        commandList.add(rdebug.toOSString());
        commandList.add(DEBUGGER_PORT_SWITCH);
        commandList.add(Integer.toString(port));
        commandList.add(END_OF_ARGUMENTS_DELIMETER);
        return commandList;
    }

    private List<IPath> getRDebugIDELocations(IPath rubyExecutablePath) {
        ArrayList<IPath> locations = new ArrayList<IPath>();
        if (rubyExecutablePath != null) {
            locations.add(rubyExecutablePath.removeLastSegments(1));
        }
        locations.add(Path.fromOSString((String)System.getProperty("user.home")).append(".gem/ruby/1.8/bin"));
        locations.add(Path.fromOSString((String)System.getProperty("user.home")).append(".gem/ruby/1.9/bin"));
        locations.add(Path.fromOSString((String)"/opt/local/bin"));
        locations.add(Path.fromOSString((String)"/usr/local/bin"));
        locations.add(Path.fromOSString((String)"/usr/bin"));
        locations.add(Path.fromOSString((String)"/bin"));
        return locations;
    }

    private Collection<? extends String> interpreterArguments(IPath rubyExecutablePath, ILaunchConfiguration configuration) throws CoreException {
        String interpreterArgs;
        ArrayList<String> arguments = new ArrayList<String>();
        String rubyVersion = RubyLaunchingPlugin.getRubyVersion((IPath)rubyExecutablePath);
        if (rubyVersion != null && (rubyVersion.contains("jruby") || rubyVersion.contains("java"))) {
            arguments.add("--debug");
            arguments.add("-X+O");
        }
        if ((interpreterArgs = configuration.getAttribute("com.aptana.ruby.debug.ATTR_VM_ARGUMENTS", null)) != null) {
            String[] raw = DebugPlugin.parseArguments((String)interpreterArgs);
            int i = 0;
            while (i < raw.length) {
                String arg = raw[i];
                if ((arg.equals("-e") || arg.equals("-X") || arg.equals("-F")) && raw.length > i + 1) {
                    arguments.add(String.valueOf(arg) + " " + raw[i + 1]);
                    ++i;
                } else {
                    arguments.add(arg);
                }
                ++i;
            }
        }
        URL url = FileLocator.find((Bundle)RubyLaunchingPlugin.getDefault().getBundle(), (IPath)Path.fromPortableString((String)"ruby/sync.rb"), null);
        try {
            File file = ResourceUtil.resourcePathToFile((URL)url);
            String filePath = file.getParent();
            arguments.add("-I");
            arguments.add(filePath);
            arguments.add("-rsync");
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)RubyLaunchingPlugin.getDefault(), (Throwable)e);
        }
        arguments.add(END_OF_ARGUMENTS_DELIMETER);
        return arguments;
    }

    protected IPath rubyExecutable(ILaunchConfiguration configuration) throws CoreException {
        IPath path = RubyLaunchingPlugin.rubyExecutablePath((IPath)this.getWorkingDirectory(configuration));
        if (path == null) {
            this.abort(Messages.RubyDebuggerLaunchDelegate_13, null);
        }
        if (!path.toFile().exists()) {
            this.abort(MessageFormat.format(Messages.RubyDebuggerLaunchDelegate_14, path), null);
        }
        return path;
    }

    private String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        String[] envp;
        HashMap<String, String> env = new HashMap<String, String>();
        if (!"win32".equals(Platform.getOS())) {
            env.putAll(ShellExecutable.getEnvironment((IPath)this.getWorkingDirectory(configuration)));
        }
        if ((envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration)) != null) {
            String[] stringArray = envp;
            int n = envp.length;
            int n2 = 0;
            while (n2 < n) {
                int eqlsign;
                String envstring = stringArray[n2];
                if (envstring.indexOf(0) != -1) {
                    envstring = envstring.replaceFirst("\u0000.*", "");
                }
                if ((eqlsign = envstring.indexOf(61)) != -1) {
                    env.put(envstring.substring(0, eqlsign), envstring.substring(eqlsign + 1));
                }
                ++n2;
            }
        }
        if (env.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : env.entrySet()) {
            list.add(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    protected IPath getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String workingDirVal = configuration.getAttribute("com.aptana.ruby.debug.ATTR_WORKING_DIR", null);
        if (workingDirVal == null) {
            return null;
        }
        IPath workingDirectory = Path.fromOSString((String)workingDirVal);
        if (!workingDirectory.toFile().isDirectory()) {
            IdeLog.logError((Plugin)RubyDebugCorePlugin.getDefault(), (String)("Specified working directory does not appear to be a valid directory: " + workingDirVal));
            return null;
        }
        return workingDirectory;
    }

    private void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "com.aptana.ruby.debug", 0, message, e));
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findFreePort() {
        ServerSocket socket = null;
        socket = new ServerSocket(0);
        int n = socket.getLocalPort();
        if (socket == null) return n;
        try {
            socket.close();
            return n;
        }
        catch (IOException iOException) {}
        return n;
        catch (IOException iOException) {
            try {
                if (socket == null) return -1;
            }
            catch (Throwable throwable) {
                if (socket == null) throw throwable;
                try {
                    socket.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                socket.close();
                return -1;
            }
            catch (IOException iOException3) {}
            return -1;
        }
    }
}

